<?php
require_once __DIR__ . '/../config/db.php';

try {
    echo "Checking activity_logs table...\n";
    
    // Check if activity_logs table exists
    $stmt = $pdo->prepare("SHOW TABLES LIKE 'activity_logs'");
    $stmt->execute();
    $tableExists = $stmt->fetch();
    
    if (!$tableExists) {
        echo "Creating activity_logs table...\n";
        
        // Create activity_logs table
        $sql = "
        CREATE TABLE activity_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            action VARCHAR(255) NOT NULL,
            details TEXT,
            ip_address VARCHAR(45),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ";
        
        $pdo->exec($sql);
        echo "Activity logs table created successfully!\n";
        
    } else {
        echo "Activity logs table already exists.\n";
    }
    
    echo "Activity logs table check completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Error during migration: " . $e->getMessage() . "\n";
    exit(1);
}
?> 